***********************************************************************
*
* teach umenu.aii -- Version 3.0 
*
* Copyright (c)
* Apple Computer, Inc.  1986-1990
* All Rights Reserved.
*
* Developer Technical Support Apple II Sample Code
*
* This file contains the code which implements  
* windows in the busybox program.
*
***********************************************************************

               case on

               copy 2/ainclude/e16.types
               copy 2/ainclude/e16.event
               copy 2/ainclude/e16.quickdraw
               copy 2/ainclude/e16.textedit
               copy teach.equ

               mcopy macros/umenu.macros

               longi on
               longa on

***********************************************************************
* doQuitItem
*
* Just set the quitFlag -- that will do it.
*
doQuitItem     start

               inc quitFlag
               rts

               end

***********************************************************************
* doAboutItem
*
* Display the vanity box.
*
doAboutItem    start

               pha
               pea refIsResource*2
               PushLong #0
               PushLong #1
               _AlertWindow
               pla
               rts

               end

***********************************************************************
* doSelectAll
*
* Tell TextEdit to select all the text for the front window.
*
doSelectAll    start

               DefineStack

thisHndl       long                     ;Must be at 1,s

saveDPage      word
returnAddr     word

******************

               phd                      ;Save directPage register.
               pha                      ;Make space for thisHndl.
               pha
               tsc
               tcd                      ;Set directPage register.

               pha                      ;Space for FrontWindow
               pha
               _FrontWindow
               PushLong #MainWindowID   ;FrontWindow and MainWindowID
               _GetCtlHandleFromID      ;are inputs for this.
*                                       ;Result is now in thisHndl.

               PushLong #0
               PushLong #$FFFFFFFF
               pei thisHndl+2
               pei thisHndl
               _TESetSelection

               pla                      ;Remove space for thisHndl.
               pla
               pld                      ;Restore directPage register
               rts

               end

***********************************************************************
* doChooseFont
*
* Use ChooseFont to select a different font, and then have TextEdit
* change the selected text in the top window.
*
doChooseFont   start

               DefineStack

thisHndl       long                     ;Must be at 1,s
thisStyle      block sizeofTEStyle
tempHndl       long

stkFrameSize   EndLocals

saveDPage      word
returnAddr     word

******************

               phd                      ;Save directPage register.
               tsc                      ;Make space for local variables.
               sec
               sbc #stkFrameSize
               tcs
               tcd                      ;Set directPage register.

               pha                      ;Create a temporary handle
               pha                      ;for GetSelection style.
               PushLong #20
               PushWord userID
               lda #0
               pha                      ;word of 0.
               pha                      ;long of 0.
               pha
               _NewHandle
               pla
               sta tempHndl
               pla
               sta tempHndl+2

               pha                      ;Space for FrontWindow
               pha
               _FrontWindow             ;FrontWindow and MainWindowID
               PushLong #MainWindowID   ;are inputs for this.
               _GetCtlHandleFromID      ;Result is now in thisHndl.
*                                       ;This is the handle to the TE
*                                       ;control for the top window.

               tsc                      ;Calculate pointer to thisStyle.
               clc
               adc #thisStyle
               pha                      ;Result space.
               pea 0                    ;Pointer to thisStyle.
               pha
               pei tempHndl+2
               pei tempHndl
               pei thisHndl+2
               pei thisHndl
               _TEGetSelectionStyle
               pla

               pha                      ;Use it as the default
               pha                      ;for ChooseFont.
               pei thisStyle+teFont+2
               pei thisStyle+teFont
               pea 0
               _ChooseFont
               pla
               sta thisStyle+teFont
               pla
               sta thisStyle+teFont+2

               tsc                      ;Calculate pointer to thisStyle.
               clc
               adc #thisStyle
               pea teReplaceFont+teReplaceSize+teReplaceAttributes
               pea 0                    ;Pointer to thisStyle.
               pha
               pei thisHndl+2
               pei thisHndl
               _TEStyleChange

               pei tempHndl+2
               pei tempHndl
               _DisposeHandle

               tsc                      ;Remove local space.
               clc
               adc #stkFrameSize
               tcs
               pld                      ;Restore directPage register.
               rts

               end

***********************************************************************
* doSetFont
*
* Change the family number for the selected text for the top window.
*
doSetFont      start

               DefineStack

thisHndl       long                     ;Must be at 1,s
thisStyle      block sizeofTEStyle

stkFrameSize   EndLocals

saveDPage      word
returnAddr     word

theFam         word

******************

               phd                      ;Save directPage register.
               tsc
               sec
               sbc #stkFrameSize        ;Make space for local variables.
               tcs
               tcd                      ;Set directPage register.

               pha                      ;Space for FrontWindow
               pha
               _FrontWindow
               PushLong #MainWindowID   ;FrontWindow and MainWindowID
               _GetCtlHandleFromID      ;are inputs for this.

               lda theFam
               sta thisStyle+teFont+ofamNum

               tsc                      ;Calculate pointer to thisStyle.
               clc
               adc #thisStyle
               pea teReplaceFont
               pea 0                    ;Pointer to thisStyle.
               pha
               pei thisHndl+2
               pei thisHndl
               _TEStyleChange

               tsc                      ;Remove local variable space.
               clc
               adc #stkFrameSize
               tcs
               pld                      ;Restore directPage register.
               plx                      ;Keep return address.
               pla                      ;Remove passed parameter.
               phx                      ;Put return address back
               rts                      ;and return.

               end

***********************************************************************
* doSetSize
*
* Change the font size for the selected text for the top window.
*
doSetSize      start

               DefineStack

thisHndl       long                     ;Must be at 1,s
thisStyle      block sizeofTEStyle

stkFrameSize   EndLocals

saveDPage      word
returnAddr     word

theSize        word

******************

               phd                      ;Save directPage register.
               tsc
               sec
               sbc #stkFrameSize        ;Make space for local variables.
               tcs
               tcd                      ;Set directPage register.

               pha                      ;Space for FrontWindow
               pha
               _FrontWindow
               PushLong #MainWindowID   ;FrontWindow and MainWindowID
               _GetCtlHandleFromID      ;are inputs for this.

               shortm
               lda theSize
               sta thisStyle+teFont+ofontSize
               longm

               tsc                      ;Calculate pointer to thisStyle.
               clc
               adc #thisStyle
               pea teReplaceSize
               pea 0                    ;Pointer to thisStyle.
               pha
               pei thisHndl+2
               pei thisHndl
               _TEStyleChange

               tsc                      ;Remove local variable space.
               clc
               adc #stkFrameSize
               tcs
               pld                      ;Restore directPage register.
               plx                      ;Keep return address.
               pla                      ;Remove passed parameter.
               phx                      ;Put return address back
               rts                      ;and return.

               end

***********************************************************************
* doSetStyle
*
*
doSetStyle     start

               DefineStack

thisHndl       long                     ;Must be at 1,s
thisStyle      block sizeofTEStyle

stkFrameSize   EndLocals

saveDPage      word
returnAddr     word

theStyle       word

******************

               phd                      ;Save directPage register.
               tsc
               sec
               sbc #stkFrameSize        ;Make space for local variables.
               tcs
               tcd                      ;Set directPage register.

               pha                      ;Space for FrontWindow
               pha
               _FrontWindow
               PushLong #MainWindowID   ;FrontWindow and MainWindowID
               _GetCtlHandleFromID      ;are inputs for this.

               shortm
               lda theStyle
               sta thisStyle+teFont+ofontStyle
               longm

               ldx #teReplaceAttributes
               lda theStyle
               beq aa
               ldx #teSwitchAttributes
aa             tsc                      ;Calculate pointer to thisStyle.
               clc
               adc #thisStyle
               phx                      ;Switch or replace.
               pea 0                    ;Pointer to thisStyle.
               pha
               pei thisHndl+2
               pei thisHndl
               _TEStyleChange

               tsc                      ;Remove local variable space.
               clc
               adc #stkFrameSize
               tcs
               pld                      ;Restore directPage register.
               plx                      ;Keep return address.
               pla                      ;Remove passed parameter.
               phx                      ;Put return address back
               rts                      ;and return.

               end

***********************************************************************
* doMenu
*
* Function to handle all menu selections.  Examines the event.TaskData
* menu item ID word from TaskMaster (from Event Manager) and calls the
* appropriate routine.  While the routine is running the menu title is
* still highlighted.  After the routine returns, we unhilight the
* menu title.
*
doMenu         start

               lda event+owmTaskData
               cmp #AboutItem
               bne aa
               jsr doAboutItem
               brl exit

aa             cmp #CloseItem
               bne ab
               jsr doCloseTop
               brl exit

ab             cmp #QuitItem
               bne ac
               jsr doQuitItem
               brl exit

ac             cmp #SelectAllItem
               bne ad
               jsr doSelectAll
               brl exit

ad             cmp #NewItem
               bne ae
               jsr doNewWindow
               brl exit

ae             cmp #OpenItem
               bne af
               jsr doOpenWindow
               brl exit

af             cmp #SaveItem
               bne ag
               jsr doSave
               brl exit

ag             cmp #SaveAsItem
               bne ah
               jsr doSaveAs
               brl exit

ah             cmp #PageSetupItem
               bne ai
*                                       ;Not implemented yet.
               brl exit

ai             cmp #PrintItem
               bne aj
*                                       ;Not implemented yet.
               brl exit

aj             cmp #PlainItem
               bne ak
               pea 0
               jsr doSetStyle
               brl exit

ak             cmp #BoldItem
               bne al
               pea boldMask
               jsr doSetStyle
               brl exit

al             cmp #ItalicItem
               bne am
               pea italicMask
               jsr doSetStyle
               brl exit

am             cmp #UnderlineItem
               bne an
               pea underlineMask
               jsr doSetStyle
               brl exit

an             cmp #ShadowItem
               bne ao
               pea shadowMask
               jsr doSetStyle
               brl exit

ao             cmp #OutlineItem
               bne ap
               pea outlineMask
               jsr doSetStyle
               brl exit

ap             cmp #Size8Item
               bne aq
               pea 8
               jsr doSetSize
               brl exit

aq             cmp #Size10Item
               bne ar
               pea 10
               jsr doSetSize
               brl exit

ar             cmp #Size12Item
               bne as
               pea 12
               jsr doSetSize
               brl exit

as             cmp #Size16Item
               bne at
               pea 16
               jsr doSetSize
               brl exit

at             cmp #Size20Item
               bne au
               pea 20
               jsr doSetSize
               brl exit

au             cmp #Size24Item
               bne av
               pea 24
               jsr doSetSize
               brl exit

av             cmp #ChooseFontItem
               bne aw
               jsr doChooseFont
               brl exit

aw             cmp #FirstFontItem
               bcc exit
               pha                      ;Result space.
               pha                      ;Item num.
               _ItemID2FamNum           ;Fam num now on stack.
               jsr doSetFont

exit           pea 0
               lda event+owmTaskData+2
               pha
               _HiliteMenu

               rts

               end

***********************************************************************
* setupMenus
*
* Function to install our menu titles and their items in the system
* menu bar and to redraw it so we can see them.
*
setupMenus     start

               pha
               pha
               pea refIsResource
               PushLong #1
               PushLong #0
               _NewMenuBar2
               _SetSysBar

               PushLong #0
               _SetMenuBar

               pea AppleMenuID
               _FixAppleMenu

               pea FontMenuID
               pea FirstFontItem
               pea 0
               _FixFontMenu

               pha
               _FixMenuBar
               pla

* Rather than drawing menu bar here, I rely on FixFrontW to do it first.

               rts

               end

               END
